import { View, Text, Pressable } from 'react-native';
import React, { useEffect, useState } from 'react';
import BackNavigation from '../../Utilities/CustomHeader/BackNavigation';
import CommonStyles from '../../Utilities/CommonStyles/CommonStyles';
import { orderSummaryStyle } from '../OrderSummary/OrderSummaryStyle';
import { OrderIndicator } from '../OrderSummary/OrderSummary';
import { billingInfoStyle } from './BillingInformationStyle';
import { useSelector, useDispatch } from 'react-redux';
import useAuth from '../../../hooks/useAuth';
import { getMyAddress } from '../../../redux/slices/user/address/getMyAddress';
import { InOnScreenLoader } from '../ShoppingCart';
import OrderAddresses from './OrderAddresses';
import AddressSkeleton from '../../../src/skeletons/screens/profile/AddressSkeleton';
import { postSelectProduct } from '../../../redux/slices/cart/selectProduct/selectProduct';
import { getCartProduct } from '../../../redux/slices/cart/getCartProducts';
import { storeSelectedItemsResData } from '../utils/storeSelectedItems';
import { loginStyles } from '../../../components/Authentication/Login/LoginStyle';
import { useIsFocused } from '@react-navigation/native';
import { resetCountry } from '../../../redux/slices/user/address/getCountries';
import { resetState } from '../../../redux/slices/user/address/getStates';
import { resetCity } from '../../../redux/slices/user/address/getCity';
import { BASE_API_URL_STG } from '@env';
import AddNewAddressBtn from './AddNewAddressBtn';
import useLangTranslation from '../../../hooks/useLangTranslation';

const CHANGE_SHIPPING_ADDRESS_URL = `${BASE_API_URL_STG}/user/order-get-shipping-tax`;
const CARTURL = `${BASE_API_URL_STG}/user/carts`;

const BillingInformation = (props) => {
    const dispatch = useDispatch();
    const { trans } = useLangTranslation();
    const { navigation } = props;
    const { access_token } = useAuth();
    const { cartLoading } = useSelector((state) => state.cartProductSlice);
    const {
        defaultAddress,
        myAddresses,
        loading: myAddressLoading,
    } = useSelector((state) => state.getMyAddress);

    const [inFileLoad, setInFileLoad] = useState(true);
    const [isChangeShippingAddress, setIsChangeShippingAddress] =
        useState(false);
    const [shippingAddress, setShippingAddress] = useState(null);
    const [borderColor, setBorderColor] = useState(null);
    const [priceData, setPriceData] = useState({});
    const [selectedProducts, setSelectedProducts] = useState([]);

    const isFocused = useIsFocused();
    useEffect(() => {
        if (isFocused) {
            dispatch(resetCountry());
            dispatch(resetState());
            dispatch(resetCity());
        }
    }, [isFocused]);

    useEffect(() => {
        (async () => {
            const res = await dispatch(getCartProduct({ access_token, CARTURL }));
            const selectedCarts = res?.payload?.records?.data?.selectedCarts;
            const cartData = res?.payload?.records?.data?.cartData;
            if (selectedCarts?.length > 0) {
                const isCheck = selectedCarts;
                const { selectedItems, priceData } = storeSelectedItemsResData(
                    isCheck,
                    cartData
                );
                setPriceData(priceData);
                setSelectedProducts(selectedItems);
                await dispatch(getMyAddress(access_token));
                setInFileLoad(false);
            } else {
                navigation.navigate('my cart');
                return;
            }
        })()
    }, []);

    const handleSelectAddress = async (address, id) => {
        if (id) {
            setIsChangeShippingAddress(true);
            const data = {
                address_id: id,
            };
            await dispatch(
                postSelectProduct({
                    access_token,
                    selectURL: CHANGE_SHIPPING_ADDRESS_URL,
                    method: 'POST',
                    data,
                })
            );
            setBorderColor(id);
            setShippingAddress(address);
            setIsChangeShippingAddress(false);
        }
    };
    useEffect(() => {
        if (Object.keys(defaultAddress).length == 0) {
            setShippingAddress(null);
        } else {
            setShippingAddress(defaultAddress);
        }
        setBorderColor(defaultAddress.id);
    }, [defaultAddress]);

    const checkoutBtn = myAddresses?.length == 0 ||shippingAddress == null || selectedProducts.length == 0 ? true : false

    return (
        <>
            {(cartLoading || isChangeShippingAddress) && <InOnScreenLoader />}
            <BackNavigation
                navigationProps={navigation}
                routeName={trans('Shipping Address')}
                capitalize={false}
            />

            <View style={CommonStyles.globalContainer}>
                <View style={orderSummaryStyle.indicatorCont}>
                    {['#33C172', '#A9DFC1', '#DFDFDF', '#DFDFDF'].map(
                        (item, i) => (
                            <OrderIndicator key={`key${i}`} bg={item} />
                        )
                    )}
                </View>
                <AddNewAddressBtn />
                {inFileLoad || myAddressLoading ? (
                    <AddressSkeleton />
                ) : (
                    <OrderAddresses
                        addresses={myAddresses}
                        borderColor={borderColor}
                        handleSelectAddress={handleSelectAddress}
                    />
                )}

                <Pressable
                    style={[
                        loginStyles.loginButton,
                        billingInfoStyle.checkoutBtn,
                        billingInfoStyle.checkoutBtnBg(shippingAddress)

                    ]}
                    onPress={() =>
                        props.navigation.navigate('order summary', {
                            priceData,
                            selectedProducts,
                            shippingAddress,
                        })
                    }
                    disabled={checkoutBtn}
                >
                    <Text style={loginStyles.loginButtonText}>
                        {trans('Checkout')}
                    </Text>
                </Pressable>
            </View>
        </>
    );
};

export default BillingInformation;
